;===== FlashSpacesGui =====
;Displays a small gui showing which space the user is moving to. Very similar to the mac. 
;test by uncommenting the following
;flashSpacesGui(1,2)	;||
;sleep 2000				;||
;flashSpacesGuiOff()	;||
;exitApp				;||
;Note- for some weird reason, if I put any main code here (ie with a return) it really slows down the hiding/showing of windows, even with a single return at the very beginning
useGui := 1
destroyGui := 2

flashSpacesGui(curDesktop, newDesktop)
{
	;Creates and displays a GUI to show the user which space he is moving to.
	;It alternates two separate gui's in order to create a new GUI on top of the old one before destroying the old one. The purpose of this is to eliminate any "blinking" of whatever is behind it as the gui is destroyed and recreated. Instead of destroying and recreating the same gui, this function creates and displays a separate gui on top of the old gui before destroying the old gui. For whatever reason, this method did not solve the problem completely.
	;global debug := true

	global arrow := determineArrowDirection(curDesktop, newDesktop)
	yPosition := A_ScreenHeight * 2/3
	global useGui, global destroyGui
	
	;Gui, Destroy	;incase this gui hasn't already been destroyed for the previous switch (i.e., using is switching multiple spaces really fast)
	
	Gui, %useGui%:Default
	Gui, +AlwaysOnTop -Caption +ToolWindow
	Gui, Color, 000000
	Gui, add, picture,   , % addSpaceImage(1,curDesktop,newDesktop)   ;%
	Gui, add, picture,   , % addSpaceImage(3,curDesktop,newDesktop)   ;%
	Gui, add, picture,ys , % addSpaceImage(2,curDesktop,newDesktop)   ;%
	Gui, add, picture,   , % addSpaceImage(4,curDesktop,newDesktop)   ;%
	if debug
	{
		Gui, font, Cwhite
		Gui, add, text,xs , Switching Desktops: `r             %curDesktop% --> %newDesktop%
	}
	;Gui, show, y%yPosition% NoActivate, Spaces
	if useGui = 1 
	{
		pos := yPosition + 0
		Gui, show, y%pos% NoActivate, Spaces
	} 
	else 
	{
		Gui, show, y%yPosition% NoActivate, Spaces
	}
	
	sleep 40						;incerting a buffer time remedies the "flicker effect"...at least on my system it does
	Gui, %destroyGui%: Destroy		;destroy the previously-created Gui, if it still exists (the gui created the previous time flashSpacesGui() was called)
	alternateGUIs()					;current gui becomes the previous; previous, destroyed gui becomes the one created next time
	
	;===== Fullscreen screenshot display =====
	;could be used for a grand view of all spaces
	;could also be used for the transition animations
;	Gui 2: +AlwaysOnTop -Caption
;	Gui 2: add, picture, x0 y0 , screenshot.png	;there is a gray border that they x0 y0 positioning deals with
;	Gui 2: show
	
}

flashSpacesGuiOff()
{
	global destroyGui
	Gui, %destroyGui%: Destroy
}

	addSpaceImage(space, curDesktop, newDesktop)
	{
		;global newDesktop
		;global curDesktop
		global arrow
		if (space = newDesktop)
			image = newDesktop.png
		else if (space = curDesktop)
			image = %arrow%
		else image = inactiveDesktop.png
		
		image := "imgs/" . image	;navigate to image folder
		return image
	}

	determineArrowDirection(curDesktop, newDesktop)
	{
		diff := newDesktop - curDesktop
		if diff = 0
			msgbox This is the same desktop
		else if (diff = 1)	;1>2, (2>3), 3>4					right
			arrow = arrowRight.png
		else if diff = -1	;2>1, (3>2), 4>3
			arrow = arrowLeft.png
		else if (abs(diff) = 2)	;UP(3>1, 4>2) DOWN(1>3, 2>4)
		{
			if (curDesktop <= 2)
				arrow = arrowDown.png
			else if (curDesktop >= 3)
				arrow = arrowUp.png
			else msgbox we have a problem  :^(
		}
		else
		{
			arrow = inactiveDesktop.png	;don't display an arrow
			if debug
				msgbox No Arrow! diff = %diff%, cur = %curdesktop%, new = %newdesktop%
		}
		return arrow
	}
	
	
	alternateGUIs()
	{
		global
		if useGui = 1
		{
			useGui := 2
			destroyGui := 1
		}
		else if useGui = 2
		{
			useGui := 1
			destroyGui := 2
		}
		else msgbox error
	}